/*
 * Decompiled with CFR 0.152.
 */
package minecrafttransportsimulator.items.instances;

import java.util.HashMap;
import java.util.Map;
import minecrafttransportsimulator.baseclasses.BezierCurve;
import minecrafttransportsimulator.baseclasses.Point3D;
import minecrafttransportsimulator.baseclasses.RotationMatrix;
import minecrafttransportsimulator.blocks.components.ABlockBase;
import minecrafttransportsimulator.blocks.instances.BlockCollision;
import minecrafttransportsimulator.blocks.instances.BlockRoad;
import minecrafttransportsimulator.blocks.tileentities.components.RoadClickData;
import minecrafttransportsimulator.blocks.tileentities.components.RoadLane;
import minecrafttransportsimulator.blocks.tileentities.instances.TileEntityRoad;
import minecrafttransportsimulator.items.components.AItemSubTyped;
import minecrafttransportsimulator.items.components.IItemBlock;
import minecrafttransportsimulator.jsondefs.JSONRoadComponent;
import minecrafttransportsimulator.jsondefs.JSONSubDefinition;
import minecrafttransportsimulator.mcinterface.AWrapperWorld;
import minecrafttransportsimulator.mcinterface.IWrapperPlayer;
import minecrafttransportsimulator.packets.instances.PacketPlayerChatMessage;
import minecrafttransportsimulator.systems.ConfigSystem;
import minecrafttransportsimulator.systems.LanguageSystem;

public class ItemRoadComponent
extends AItemSubTyped<JSONRoadComponent>
implements IItemBlock {
    private final Map<IWrapperPlayer, Point3D> lastRoadGenPositionClicked = new HashMap<IWrapperPlayer, Point3D>();
    private final Map<IWrapperPlayer, RotationMatrix> lastRoadGenRotationClicked = new HashMap<IWrapperPlayer, RotationMatrix>();
    private final Map<IWrapperPlayer, RoadClickData> lastRoadGenClickedData = new HashMap<IWrapperPlayer, RoadClickData>();

    public ItemRoadComponent(JSONRoadComponent definition, JSONSubDefinition subDefinition, String sourcePackID) {
        super(definition, subDefinition, sourcePackID);
    }

    @Override
    public boolean onBlockClicked(AWrapperWorld world, IWrapperPlayer player, Point3D position, ABlockBase.Axis axis) {
        if (!world.isClient()) {
            TileEntityRoad clickedRoad;
            ABlockBase clickedBlock = world.getBlock(position);
            if (clickedBlock instanceof BlockRoad && !(clickedRoad = (TileEntityRoad)world.getTileEntity(position)).isActive()) {
                return false;
            }
            if (((JSONRoadComponent)this.definition).road.type.equals((Object)TileEntityRoad.RoadComponent.CORE_DYNAMIC)) {
                clickedRoad = clickedBlock instanceof BlockRoad ? (TileEntityRoad)world.getTileEntity(position) : (clickedBlock instanceof BlockCollision ? ((BlockCollision)clickedBlock).getMasterRoad(world, position) : null);
                if (player.isSneaking() || !this.lastRoadGenPositionClicked.containsKey(player)) {
                    this.lastRoadGenPositionClicked.remove(player);
                    this.lastRoadGenRotationClicked.remove(player);
                    this.lastRoadGenClickedData.remove(player);
                    if (clickedRoad != null) {
                        RoadClickData clickedRoadData = clickedRoad.getClickData(position, false);
                        JSONRoadComponent.JSONRoadGeneric roadDefinition = ((JSONRoadComponent)clickedRoadData.roadClicked.definition).road;
                        if ((roadDefinition.type.equals((Object)TileEntityRoad.RoadComponent.CORE_DYNAMIC) ? roadDefinition.laneOffsets.length : clickedRoadData.sectorClicked.lanes.size()) != ((JSONRoadComponent)this.definition).road.laneOffsets.length) {
                            player.sendPacket(new PacketPlayerChatMessage(player, LanguageSystem.INTERACT_ROAD_LANEMISMATCHFIRST, new Object[0]));
                            return true;
                        }
                        if (clickedRoadData.lanesOccupied) {
                            player.sendPacket(new PacketPlayerChatMessage(player, LanguageSystem.INTERACT_ROAD_ALREADYCONNECTED, new Object[0]));
                            return true;
                        }
                        this.lastRoadGenPositionClicked.put(player, clickedRoadData.genPosition);
                        this.lastRoadGenRotationClicked.put(player, clickedRoadData.genRotation);
                        this.lastRoadGenClickedData.put(player, clickedRoadData);
                    } else {
                        RotationMatrix genRotation = new RotationMatrix().rotateY(Math.round(player.getYaw() / 15.0f) * 15);
                        Point3D genPosition = ((JSONRoadComponent)this.definition).road.cornerOffset.copy().invert();
                        genPosition.z -= (double)((JSONRoadComponent)this.definition).road.segmentLength;
                        genPosition.rotate(genRotation);
                        genPosition.add(position).add(0.5, 1.0, 0.5);
                        this.lastRoadGenPositionClicked.put(player, genPosition);
                        this.lastRoadGenRotationClicked.put(player, genRotation);
                    }
                    player.sendPacket(new PacketPlayerChatMessage(player, LanguageSystem.INTERACT_ROAD_SET, new Object[0]));
                } else if (!player.isSneaking() && this.lastRoadGenPositionClicked.containsKey(player)) {
                    if (position.isDistanceToCloserThan(this.lastRoadGenPositionClicked.get(player), ((Integer)ConfigSystem.settings.general.roadMaxLength.value).intValue())) {
                        RotationMatrix endRotation;
                        Point3D endPosition;
                        Point3D blockPlacementPoint;
                        RotationMatrix startRotation;
                        Point3D startPosition;
                        if (clickedRoad != null) {
                            RoadClickData startingRoadData = clickedRoad.getClickData(position, true);
                            JSONRoadComponent.JSONRoadGeneric roadDefinition = ((JSONRoadComponent)startingRoadData.roadClicked.definition).road;
                            if ((roadDefinition.type.equals((Object)TileEntityRoad.RoadComponent.CORE_DYNAMIC) ? roadDefinition.laneOffsets.length : startingRoadData.sectorClicked.lanes.size()) != ((JSONRoadComponent)this.definition).road.laneOffsets.length) {
                                player.sendPacket(new PacketPlayerChatMessage(player, LanguageSystem.INTERACT_ROAD_LANEMISMATCHSECOND, new Object[0]));
                                return true;
                            }
                            if (startingRoadData.lanesOccupied) {
                                player.sendPacket(new PacketPlayerChatMessage(player, LanguageSystem.INTERACT_ROAD_ALREADYCONNECTED, new Object[0]));
                                return true;
                            }
                            startPosition = startingRoadData.genPosition;
                            startRotation = startingRoadData.genRotation;
                            blockPlacementPoint = startPosition.copy();
                            blockPlacementPoint.x = Math.floor(blockPlacementPoint.x);
                            blockPlacementPoint.z = Math.floor(blockPlacementPoint.z);
                            boolean foundSpot = false;
                            for (int i = -1; i < 1 && !foundSpot; ++i) {
                                for (int j = -1; j < 1 && !foundSpot; ++j) {
                                    blockPlacementPoint.add(i, 0.0, j);
                                    if (world.isAir(blockPlacementPoint)) {
                                        foundSpot = true;
                                        continue;
                                    }
                                    blockPlacementPoint.add(-i, 0.0, -j);
                                }
                            }
                            if (!foundSpot) {
                                player.sendPacket(new PacketPlayerChatMessage(player, LanguageSystem.INTERACT_ROAD_BLOCKED, new Object[0]));
                                return true;
                            }
                        } else {
                            blockPlacementPoint = position.copy().add(0.0, 1.0, 0.0);
                            startRotation = new RotationMatrix().rotateY(Math.round(player.getYaw() / 15.0f) * 15);
                            startPosition = ((JSONRoadComponent)this.definition).road.cornerOffset.copy().rotate(startRotation).add(0.5, 0.0, 0.5).add(blockPlacementPoint);
                        }
                        if (this.lastRoadGenClickedData.containsKey(player)) {
                            RoadClickData endingRoadData = this.lastRoadGenClickedData.get(player);
                            endPosition = endingRoadData.genPosition;
                            endRotation = endingRoadData.genRotation;
                        } else {
                            endPosition = this.lastRoadGenPositionClicked.get(player);
                            endRotation = this.lastRoadGenRotationClicked.get(player);
                        }
                        if (startPosition.equals(this.lastRoadGenPositionClicked.get(player))) {
                            player.sendPacket(new PacketPlayerChatMessage(player, LanguageSystem.INTERACT_ROAD_SAME, new Object[0]));
                            return true;
                        }
                        ABlockBase oldBlock = world.getBlock(blockPlacementPoint);
                        if (oldBlock instanceof BlockCollision) {
                            TileEntityRoad road = ((BlockCollision)oldBlock).getMasterRoad(world, position);
                            road.collisionBlockOffsets.remove(blockPlacementPoint.copy().subtract(road.position));
                        }
                        if (world.setBlock(this.getBlock(), blockPlacementPoint, player, axis)) {
                            TileEntityRoad newRoad = (TileEntityRoad)world.getTileEntity(blockPlacementPoint);
                            newRoad.dynamicCurve = new BezierCurve(startPosition, endPosition, startRotation, endRotation);
                            if (newRoad.spawnCollisionBlocks(player)) {
                                for (RoadLane lane : newRoad.lanes) {
                                    lane.generateConnections();
                                }
                                RoadClickData clickData = newRoad.getClickData(newRoad.position, false);
                                this.lastRoadGenClickedData.put(player, clickData);
                                this.lastRoadGenPositionClicked.put(player, clickData.genPosition);
                                this.lastRoadGenRotationClicked.put(player, clickData.genRotation);
                            }
                        } else {
                            player.sendPacket(new PacketPlayerChatMessage(player, LanguageSystem.INTERACT_ROAD_BLOCKED, new Object[0]));
                        }
                    } else {
                        player.sendPacket(new PacketPlayerChatMessage(player, LanguageSystem.INTERACT_ROAD_TOOFAR, new Object[0]));
                    }
                    return true;
                }
            } else if (((JSONRoadComponent)this.definition).road.type.equals((Object)TileEntityRoad.RoadComponent.CORE_STATIC)) {
                Point3D blockPlacementPoint = position.copy().add(0.0, 1.0, 0.0);
                if (world.setBlock(this.getBlock(), blockPlacementPoint, player, axis)) {
                    TileEntityRoad newRoad = (TileEntityRoad)world.getTileEntity(blockPlacementPoint);
                    if (newRoad.spawnCollisionBlocks(player)) {
                        for (RoadLane lane : newRoad.lanes) {
                            lane.generateConnections();
                        }
                    }
                } else {
                    player.sendPacket(new PacketPlayerChatMessage(player, LanguageSystem.INTERACT_ROAD_BLOCKED, new Object[0]));
                }
                return true;
            }
        }
        return false;
    }

    @Override
    public Class<? extends ABlockBase> getBlockClass() {
        return BlockRoad.class;
    }

    @Override
    public ABlockBase createBlock() {
        return new BlockRoad();
    }
}

